/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.graphic.FontChange;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorSet;

class ColorChange
implements FontChange {
    private static final Pattern colorPattern = MyPattern.cmpile("(?i)\\<color[\\s:]+(#[0-9a-fA-F]{6}|#?\\w+)[%s]*\\>");
    private final HtmlColor color;

    ColorChange(String s) {
        Matcher matcherColor = colorPattern.matcher(s);
        if (!matcherColor.find()) {
            throw new IllegalArgumentException();
        }
        this.color = HtmlColorSet.getInstance().getColorIfValid(matcherColor.group(1));
    }

    HtmlColor getColor() {
        return this.color;
    }

    @Override
    public FontConfiguration apply(FontConfiguration initial) {
        return initial.changeColor(this.color);
    }
}

